package com.hero.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.enhancers.Enhancer;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class PerksPanel extends AbilityPanel {

	private class PerkEnhancerMenuItem extends JCheckBoxMenuItem {
		private static final long serialVersionUID = -907338421826327588L;

		PerksPanel parent;

		String xmlID;

		public PerkEnhancerMenuItem(PerksPanel par, String display, String ID) {
			super(display);
			xmlID = ID;
			parent = par;
			addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					ArrayList<GenericObject> enhancers = HeroDesigner
							.getActiveHero().getPerks();
					if (isSelected()) {
						for (int i = 0; i < enhancers.size(); i++) {
							GenericObject obj = enhancers.get(i);
							if (obj.getXMLID().equals(xmlID)) {
								return; // already purchased
							}
						}
						LOOP: for (int i = 0; i < HeroDesigner
								.getActiveTemplate().getSkillEnhancers().size(); i++) {
							GenericObject obj = HeroDesigner
									.getActiveTemplate().getSkillEnhancers()
									.get(i);
							if (obj.getXMLID().equals(xmlID)) {
								GenericObject o2 = obj.clone();
								parent.selectionList.addObject(o2);
								break LOOP;
							}
						}
					} else {
						LOOP: for (int i = 0; i < enhancers.size(); i++) {
							GenericObject obj = enhancers.get(i);
							if (obj.getXMLID().equals(xmlID)) {
								Enhancer en = (Enhancer) obj;
								for (int j = 0; j < en.getObjects().size(); j++) {
									GenericObject member = en.getObjects().get(
											j);
									member.setParent(null);
								}
								enhancers.remove(i);
								HeroDesigner.getActiveHero().setDirty(true);
								break LOOP;
							}
						}
					}
					parent.selectionList.updateTotal();
				}
			});
		}

		public String getXMLID() {
			return xmlID;
		}
	}

	private static final long serialVersionUID = 6252023160245160014L;

	JMenu perkEnhancersMenu;

	public PerksPanel() {
		super();
	}

	protected void checkIndices() {
		selectionList.checkIndices();
	}

	@Override
	protected GenericObjectList createSelectionList() {
		return new PerksList();
	}

	@Override
	protected String getAvailableLabel() {
		return "Perks";
	}

	@Override
	protected ArrayList<GenericObject> getAvailableObjects() {
		return HeroDesigner.getActiveTemplate().getPerks();
	}

	@Override
	protected ArrayList<GenericObject> getAvailablePrefabs() {
		return HeroDesigner.getInstance().getPrefabPerks();
	}

	@Override
	protected ArrayList<GenericObject> getObjects() {
		return HeroDesigner.getActiveHero().getPerks();
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		perkEnhancersMenu.addMenuListener(new MenuListener() {
			public void menuCanceled(MenuEvent e) {

			}

			public void menuDeselected(MenuEvent e) {

			}

			public void menuSelected(MenuEvent e) {
				// check to see if it should be deselected...
				for (int j = 0; j < perkEnhancersMenu.getItemCount(); j++) {
					boolean found = false;
					PerkEnhancerMenuItem enhancerMI = (PerkEnhancerMenuItem) perkEnhancersMenu
							.getItem(j);
					INNER: for (int i = 0; i < HeroDesigner.getActiveHero()
							.getPerks().size(); i++) {
						GenericObject o = HeroDesigner.getActiveHero()
								.getPerks().get(i);
						if (o.getXMLID().equals(enhancerMI.getXMLID())) {
							found = true;
							break INNER;
						}
						enhancerMI.setSelected(found);
					}
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		perkEnhancersMenu = new JMenu("Perk Enhancers");
		// initialize perk enhancers...
		ArrayList<GenericObject> enhancers = HeroDesigner.getActiveTemplate()
				.getSkillEnhancers();
		for (int i = 0; i < enhancers.size(); i++) {
			GenericObject enhancer = enhancers.get(i);
			if (!(enhancer.getXMLID().equalsIgnoreCase("WELL_CONNECTED"))) {
				continue; // Only WellConnected belongs on the Perks Tab....
			}
			PerkEnhancerMenuItem mi = new PerkEnhancerMenuItem(this, enhancer
					.getDisplay(), enhancer.getXMLID());
			for (int j = 0; j < HeroDesigner.getActiveHero().getPerks().size(); j++) {
				GenericObject comp = HeroDesigner.getActiveHero().getPerks()
						.get(j);
				if (comp.getXMLID().equals(enhancer.getXMLID())) {
					mi.setSelected(true);
				}
			}
			perkEnhancersMenu.add(mi);
		}
		menuBar.add(perkEnhancersMenu);
	}

	@Override
	protected boolean isEquipment() {
		return false;
	}

	@Override
	protected boolean isPower() {
		return false;
	}

	@Override
	public void reset() {
		selectionList.setData(HeroDesigner.getActiveHero().getPerks());
		availableList.setAvailableList(HeroDesigner.getActiveTemplate()
				.getPerks());
		perkEnhancersMenu.removeAll();
		ArrayList<GenericObject> enhancers = HeroDesigner.getActiveTemplate()
				.getSkillEnhancers();
		for (int i = 0; i < enhancers.size(); i++) {
			GenericObject enhancer = enhancers.get(i);
			if (!(enhancer.getXMLID().equalsIgnoreCase("WELL_CONNECTED"))) {
				continue; // Only WellConnected belongs on the Perks Tab....
			}
			PerkEnhancerMenuItem mi = new PerkEnhancerMenuItem(this, enhancer
					.getDisplay(), enhancer.getXMLID());
			for (int j = 0; j < HeroDesigner.getActiveHero().getPerks().size(); j++) {
				GenericObject comp = HeroDesigner.getActiveHero().getPerks()
						.get(j);
				if (comp.getXMLID().equals(enhancer.getXMLID())) {
					mi.setSelected(true);
				}
			}
			perkEnhancersMenu.add(mi);
		}
		perkEnhancersMenu.setVisible(perkEnhancersMenu.getItemCount() > 0);
	}
}